/*
 * XXXX 
 *
 * Fecha 15/05/2007
 * 
 *  
 */
 
package com.ejie.p06b.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import n38c.exe.N38API;

import com.ejie.p06b.excel.P06BIExcel;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BResources;
import com.ejie.p06b.xlnet.P06BPerfilUsuario;

/**
	Servlet que genera el excel y lo enva a la ruta correspondiente
	Posibles Excepciones que se capturan:
		-- Excepcin genrica
*/
public class P06BEXCELServlet extends P06BServlet {
	/**
	Proceso de la servlet
	*
	*/
	
	public void init() throws ServletException {
	}
	//Process the HTTP Get request
	public void doGet(HttpServletRequest request, HttpServletResponse response) {
		N38API   n38API   = null;
		
		String tipoEXCEL= request.getParameter("tipoEXCEL");
		String ficheroEXCEL=null;
		try {
			//P06BLog.send(2,this.getClass().getName(), "Antes");
			//Idependiente por cada EXCEL
			String idioma = getIdioma(request, response);
			P06BLog.send(2,this.getClass().getName(), "Idioma: "+ idioma);
			P06BIExcel excelClass = (P06BIExcel) Class.forName("com.ejie.p06b.excel."+tipoEXCEL).newInstance();
			ficheroEXCEL = excelClass.getEXCEL(request);
			//P06BLog.send(2,this.getClass().getName(), "Ruta Excel: "+ ficheroEXCEL);
			if(ficheroEXCEL!=null && !ficheroEXCEL.equals("1")){
				escribirEXCEL(request,ficheroEXCEL,response,tipoEXCEL);
			}else{
				//Error
				new Exception("Error en el servlet al generar el EXCEL");
			}
		} catch (Exception e) {
			manejarErrores (request, response, e);
	        return;
		}
	}
	
	//Process the HTTP Post request
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doGet(request, response);
	}
	
	private void escribirEXCEL(HttpServletRequest request, String ficheroExcel,HttpServletResponse response, String tipoEXCEL) throws IOException{
//		N38API   n38API   = null;
		// Creo un objeto N38API y lo meto en la sesion si no existe.
		// Es necesario crear el objeto para poder utilizar el API de XL-Net-s.
/*//		try{
			n38API = (N38API)getObjetoSesion(P06BConstantes.P06B_N38API, request, response);			
			if (n38API==null)
			{
				P06BLog.send(0,this,"Objeto N38 es null");
				n38API = new N38API(request);
			     	setObjetoSesion (P06BConstantes.P06B_N38API, n38API, request, response);				
			}
		
			P06BLog.send(2,this, "n38API="+(n38API==null));
			P06BPerfilUsuario lPerfil = new P06BPerfilUsuario("");
			P06BLog.send(2,this, "lPerfil="+(lPerfil==null));
//			lPerfil.cargarPerfil(request, n38API);
//			String idioma = getIdioma(request, response);
//			if (lPerfil.getIdIdioma()==P06BPerfilUsuario.IDIOMA_CAST){
//				lPerfil.cambioIdioma();
//			}
			P06BLog.send(2,this, "lPerfil="+(lPerfil==null));
			setObjetoSesion (P06BConstantes.P06B_VAR_PERFIL_USUARIO, lPerfil, request, response);
			P06BLog.send(2,this, "lPerfil="+(lPerfil==null));
			marcarSesion(request, response);
			
			P06BLog.send(2,this, P06BConstantes.P06B_RES_ETIQUETAS);
*/
//	    	String idioma = (String)request.getAttribute(P06BConstantes.P06B_VAR_PERFIL_USUARIO);	
			// Gestin del idioma
//			P06BResources res = new P06BResources (new Locale(idioma),P06BConstantes.P06B_RES_ETIQUETAS);
			P06BResources res = (P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS);
			File fileEXCEL = new File(ficheroExcel);
	        FileInputStream fin=new FileInputStream(fileEXCEL);
	        ServletOutputStream out = response.getOutputStream();
	        response.setContentType("application/vnd.ms-excel");
	        String attachmentName = "";
	        if (tipoEXCEL.equals(P06BConstantes.P06B_INFORMEDETALLENEGOCIO)){
	        	attachmentName = "listados.excel01.nombreFichero";
	        }else if (tipoEXCEL.equals(P06BConstantes.P06B_INFORMEPETTRAMITAGUNEPDF)){
	        	attachmentName = "listados.excel02.nombreFichero";
	        }else if (tipoEXCEL.equals(P06BConstantes.P06B_INFORMECOMUNICARDGSFP2PDF)){
	        	attachmentName = "listados.excel03.nombreFichero";
	        }
    		response.setHeader("Content-Disposition", "attachment;filename="+res.get(attachmentName));
	        int dato;
	        while (-1!=(dato=fin.read()))
	        	out.write(dato);
	        fin.close();
	        if(fileEXCEL.exists())
	        	fileEXCEL.delete();
			
//		}
//		catch (Exception e){
//	      	manejarErrores (request, response, e);
//	        return;
//	    }

	}
}
